package kz.gamma;

import kz.gamma.jce.provider.GammaTechProvider;

import javax.naming.Context;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;

/**
 * Пример, демонстрирующий отправку расширенного LDAP запроса на службы Certex
 */
public class SampleSendLDAPexRequest {

    /**
     * @param args
     */
    public static void main(String[] args) {
        try {
            // Данный метод добавляет JCE в окружение java.security.
            Security.addProvider(new GammaTechProvider());
            // Чтение сертификата
            X509Certificate cert = loadCertFromFile("C:\\client1.cer");
            // Отправка запроса на службу Verify
            byte[] resp = sendRequest(cert.getEncoded(), "ldap://192.168.12.6:62222", "1.3.6.1.4.1.6801.11.1.4");
            if (resp == null) {
                System.out.println("Сертификат не действительный.");
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }

    }

    /**
     * Метод, отсылающий запрос на сервер Certex
     *
     * @param req
     * @param url
     * @param OIDService
     * @return
     */
    public static byte[] sendRequest(byte[] req, String url, String OIDService) {
        byte[] resp = null;
        LdapContext ctx = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
            env.put(Context.SECURITY_AUTHENTICATION, "SIMPLE");
            env.put(Context.PROVIDER_URL, url);
            env.put(Context.SECURITY_PRINCIPAL, "");
            env.put(Context.SECURITY_CREDENTIALS, "");
            ctx = new InitialLdapContext(env, null);

            RegisterRequest request1 = new RegisterRequest(req, OIDService);
            ExtendedResponse response = ctx.extendedOperation(request1);
            resp = response.getEncodedValue();
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            if (ctx != null) {
                try {
                    ctx.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return resp;
    }

    /**
     * Метод загружает сертификат из файла
     *
     * @param fileName
     * @return
     */
    public static X509Certificate loadCertFromFile(String fileName) {
        X509Certificate cert = null;
        byte[] buf = null;
        try {
            FileInputStream f = new FileInputStream(fileName);
            buf = new byte[f.available()];
            f.read(buf, 0, f.available());
            // Указываем классу CertificateFactory что необходимо использовать JCE GAMMA.
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "GAMMA");
            cert = (X509Certificate) cf.generateCertificate(new ByteArrayInputStream(buf));
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return cert;
    }
}